/**
 * \file: sdc_daemon_arch.h
 *
 * \brief : Definition of SDC function which have to be implemented in each
 * architecture dependent part using sdc_daemon_interface.c
 *
 * <b>SDC private header</b>\n
 *
 * \author: Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2017 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#ifndef __SDC_LIB_DAEMON_ARCH_H_
#define __SDC_LIB_DAEMON_ARCH_H_

#include <sdc.h>
#include <sdc_session.h>
#include <sdc_op_common.h>
#include <private/sdc_intern.h>
#include <private/sdc_arch.h>
#include <sdc/daemon/arch/sdc_daemon_arch.h>

/**
 * \ingroup arch_gen
 * \brief Function to unwrap the key and convert to the format useable by sdc daemon
 *
 * daemon_data will be allocated internally and freed by callee
 * In case the daemon does not need to be called
 * (completely handled in libsdc arch)
 * return *daemon_data = NULL and *daemon_data_len = 0
 */
SDC_ARCH_API sdc_error_t sdc_arch_wrapped_storage_key_to_daemon_data(
    sdc_session_t *session,
    const sdc_keystore_key_cfg_t *key_config,
    const sdc_wrapped_key_t *wrapped_key,
    uint8_t **daemon_data, size_t *daemon_data_len);

#endif
